﻿using System;
using System.Collections;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using NUnit.Framework;
using Inet.Viewer.WinForms.Prompt;
using Inet.Viewer.Data;

namespace Inet.Viewer.test.WinForms
{
    [TestFixture]
    class TestMultiPrompt
    {
        [Test]
        public void TestMultiPrompts()
        {
            PromptData p = new PromptData("name", "name", null, null, new string[] { }, new string[] { }, PromptData.String,
                true, true, true, true, false, false, null, null, null);
            PromptPanelBuilder b = new PromptPanelBuilder();
            Control c = b.CreateControlFor(p, null);
            Assert.NotNull(c);
            MultiPromptField f = (MultiPromptField)c;
            SinglePromptField single = f.pnlSingle as SinglePromptField;
            Assert.IsFalse(single.chkNoValue.Visible);
            Assert.IsFalse(f.btnDeleteEntry.Enabled);

            single.txtValueBox.Text = "abc";
            f.btnAddSingle.PerformClick();
            Assert.AreEqual(1, f.listBox.Items.Count);
            f.listBox.SelectedIndex = 0;
            Assert.IsTrue(f.btnDeleteEntry.Enabled);
            f.btnDeleteEntry.PerformClick();
            Assert.AreEqual(0, f.listBox.Items.Count);
            Assert.IsFalse(f.btnDeleteEntry.Enabled);

            single.txtValueBox.Text = "abc";
            f.btnAddSingle.PerformClick();
            Assert.AreEqual(1, f.listBox.Items.Count);
            f.listBox.SelectedIndex = 0;
            Assert.IsTrue(f.btnDeleteEntry.Enabled);
            f.btnDeleteEntry.PerformClick();
            Assert.AreEqual(0, f.listBox.Items.Count);
            Assert.IsFalse(f.btnDeleteEntry.Enabled);
        }

        [Test]
        public void TestMultiPromptEntersAlreadyChosenValueAtEnter()
        {
            PromptData p = new PromptData("name", "name", null, null, new string[] { }, new string[] { }, PromptData.String,
                true, true, true, true, false, false, null, null, null);
            p.ChosenValues = new ArrayList(new string[] { "ABC" });
            PromptPanelBuilder b = new PromptPanelBuilder();
            Control c = b.CreateControlFor(p, null);
            Assert.NotNull(c);
            MultiPromptField f = (MultiPromptField)c;
            Assert.AreEqual(1, f.listBox.Items.Count);
            Assert.AreEqual("", ((SinglePromptField)f.pnlSingle).txtValueBox.Text);
        }
        [Test]
        public void TestMultiPromptEntersAlreadyChosenValueAtEnterWithDefaultValues()
        {
            PromptData p = new PromptData("name", "name", null, null, new string[] { "a","b","c _to_ d" }, new string[] { "adesc","bdesc","cdesc" }, PromptData.String,
                true, true, true, true, false, false, null, null, null);
            p.ChosenValues = new ArrayList(new string[] { "ABC" });
            PromptPanelBuilder b = new PromptPanelBuilder();
            Control c = b.CreateControlFor(p, null);
            Assert.NotNull(c);
            MultiPromptField f = (MultiPromptField)c;
            Assert.AreEqual(1, f.listBox.Items.Count);
            Assert.AreEqual("a - adesc", ((SinglePromptFieldWithDefaultValues)f.pnlSingle).cmbDefaultValues.Text);
            Assert.AreEqual("", ((RangePromptFieldWithDefaultValues)f.pnlRange).cmbDefaultValues.Text);
        }
        [Test]
        public void TestMultiPromptEntersWithoutChosenValueWithDefaultValues()
        {
            PromptData p = new PromptData(
                "multiwithrangedef", null, "desc", new string[] { "a", "b", "c to d" },
                new string[] { "desca", "descb", "descc" },
                PromptData.String, true, true, true, true, false,
                false, null, null, null);
            PromptPanelBuilder b = new PromptPanelBuilder();
            Control c = b.CreateControlFor(p, null);
            Assert.NotNull(c);
            MultiPromptField f = (MultiPromptField)c;
            Assert.AreEqual(0, f.listBox.Items.Count);
            Assert.AreEqual("a - desca", ((SinglePromptFieldWithDefaultValues)f.pnlSingle).cmbDefaultValues.Text);
            Assert.AreEqual("", ((RangePromptFieldWithDefaultValues)f.pnlRange).cmbDefaultValues.Text);
        }
    }
}
